<?php

namespace App\Http\Controllers\Api\Employee\Section;

use App\Models\Section;
use App\Trait\ApiTrait;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Helper\CompanyHelper;
use App\Http\Requests\Api\Employee\Section\StoreSectionRequest;
use App\Http\Requests\Api\Employee\Section\UpdateSectionRequest;
use App\Http\Resources\CareerSectionResource;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;

class SectionController extends Controller
{
    use ApiTrait;

    public function index(Request $request)
    {
        $this->authorize('view sections');

        return $this->apiResponse(data: CareerSectionResource::collection(CompanyHelper::getCompany()->sections()->where('type', Section::SECTION_TYPE)->get()));
    }

    public function show(Section $section)
    {
        $this->authorize('show sections');

        if ($section->type !== Section::SECTION_TYPE) {
            throw new NotFoundHttpException();
        }

        return $this->apiResponse(data: CareerSectionResource::make($section));
    }

    public function store(StoreSectionRequest $request)
    {
        $this->authorize('create sections');

        return $this->apiResponse(
            message: __('messages.section_created_successfully'),
            data: CareerSectionResource::make(CompanyHelper::getCompany()->sections()->create($request->validated()))
        );
    }
    public function update(UpdateSectionRequest $request, Section $section)
    {
        $this->authorize('edit sections');

        if ($section->type !== Section::SECTION_TYPE) {
            throw new NotFoundHttpException();
        }

        $section->update($request->all());

        return $this->apiResponse(message: __('messages.section_updated_successfully'), data: CareerSectionResource::make($section));;
    }
    public function destroy(Section $section)
    {
        $this->authorize('delete sections');

        if ($section->type !== Section::SECTION_TYPE) {
            throw new NotFoundHttpException();
        }
        $section->delete();
        return $this->apiResponse(message: __('messages.section_deleted_successfully'));;
    }
}
