<?php

namespace App\Http\Controllers\Api\Feature;

use App\Http\Controllers\Controller;
use App\Http\Resources\AdvantageResource;
use App\Models\Advantage;

use Illuminate\Http\Request;
use App\Trait\ApiTrait;

class FeatureController extends Controller
{
    
    use ApiTrait;

     public function index(Request $request)
    {
        
        $features= Advantage::where("type","Feature")->get();
        $about= Advantage::where("type","About")->get();
        $whoAretContent= Advantage::where("type","WhoAreContent")->get();
        $whoAreHeader= Advantage::where("type","WhoAreHeader")->get();
        $blogs= Advantage::where("type","Blog")->get();
        return $this->apiResponse(
        data: [
            "features" => AdvantageResource::collection($features),
            "about" => AdvantageResource::collection($about),
            "whoAreContent" => AdvantageResource::collection($whoAretContent),
            "whoAreHeader" => AdvantageResource::collection($whoAreHeader),
            "blog" => AdvantageResource::collection($blogs),
        ]
    );
    }
    // public function aboutUs()
    // {
    //     return $this->apiResponse(
    //         data: AdvantageResource::collection(
    //             Advantage::where("type","About")->get()
    //         )
    //     );
    // }
}
