<?php

namespace App\Http\Controllers\Api\Location;

use App\Models\Country;
use App\Trait\ApiTrait;
use App\Models\Location;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Resources\LocationResource;

class LocationController extends Controller
{
    use ApiTrait;

    public function index(Request $request)
    {
        return $this->apiResponse(
            data: LocationResource::collection(
                Location::when(
                    $request->has('location'),
                    fn ($q) => $q->where('id', $request->location)->with(['children']),
                    fn ($q) => $q->whereNull('parent_id'),
                )->get()
            )
        );
    }

    public function countries()
    {
        $countries = Country::whereNull('city_id')->get();
        $countries = LocationResource::collection($countries);
        return $this->apiResponse(data: $countries);
    }

    public function cities(Country $country)
    {
        $countries = $country->cities;
        $countries = LocationResource::collection($countries);
        return $this->apiResponse(data: $countries);
    }

    public function areas(Country $area)
    {
        $areas = $area->areas;
        $areas = LocationResource::collection($areas);
        return $this->apiResponse(data: $areas);
    }
}
