<?php

namespace App\Http\Controllers\Api\Package;

use App\Models\Package;
use App\Trait\ApiTrait;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Resources\PackageResource;

class PackageController extends Controller
{
    use ApiTrait;

    public function index(Request $request)
    {
        return $this->apiResponse(
            data: PackageResource::collection(
                Package::when(
                    $request->has('free-package'),
                    fn ($query) => $query->free()
                )
                    ->with(['features'])
                    ->get()
            ),
        );
    }
}
