<?php

namespace App\Http\Controllers\Api\Service;

use App\Models\Service;
use App\Trait\ApiTrait;
use App\Http\Controllers\Controller;
use App\Http\Helper\CompanyHelper;
use App\Http\Services\ServiceService;
use App\Http\Requests\Api\Service\StoreServiceRequest;
use App\Http\Requests\Api\Service\UpdateServiceRequest;
use App\Http\Requests\DeleteServiceRequest;
use App\Http\Resources\ServiceResource;
use Illuminate\Http\Request;

class ServiceController extends Controller
{
    use ApiTrait;

    public function __construct(
        public ServiceService $serviceService
    ) {}

    public function index()
    {
        $this->authorize('view services');

        return $this->apiResponse(
            data: ServiceResource::collection(CompanyHelper::getCompany(request())->services)
        );
    }

    public function show(Service $service)
    {
        $this->authorize('show services');

        $service->load([
            'productServiceUnits',
            'branches',
        ]);
        return $this->apiResponse(data: ServiceResource::make($service));
    }

    public function store(StoreServiceRequest $request)
    {
        $this->authorize('create services');

        return $this->apiResponse(
            data: ServiceResource::make($this->serviceService->create($request->validated())),
            message: __('messages.service_created_successfully'),
        );
    }

    public function update(UpdateServiceRequest $request, Service $service)
    {
        $this->authorize('edit services');

        $this->serviceService->update($service, $request->validated());
        return $this->apiResponse(
            data: ServiceResource::make($service),
            message: __('messages.service_updated_successfully'),
        );
    }

    public function destroy(DeleteServiceRequest $request, Service $service = null)
    {
        $this->authorize('delete services');
        if ($service) {
            $service->delete();
            return $this->apiResponse(message: __('messages.service_deleted_successfully'));
        } else {
            if (is_array($request->ids)) {
                Service::whereIn('id', $request->ids)->delete();
                return $this->apiResponse(message: __('messages.services_deleted_successfully'));
            }
        }
    }
}
