<?php

namespace App\Http\Controllers\Api\Shipments;

use App\Http\Controllers\Controller;
use App\Http\Helper\CompanyHelper;
use App\Http\Requests\CancelShipmentRequest;
use App\Http\Requests\UpdateShipmentStatusRequest;
use App\Http\Resources\ShipmentResource;
use App\Models\RejectedShipment;
use App\Models\Shipment;
use Illuminate\Database\Eloquent\ModelNotFoundException;

class DeliveryShipmentController extends Controller
{


    public function getWaitingShipments()
    {
        //assigned shipments (status =3)
        return $this->apiResponse(data: ShipmentResource::collection(Shipment::where('delivery_id', auth()->user()->id)
            ->where('company_id',  CompanyHelper::getId())
            ->where('status', 3)
            ->get()));
    }
    public function getAcceptedShipments()
    {
        //delivery accepted these shipments (status =4 accepted or 5 = accepted from warehouse 6 = pending)
        return $this->apiResponse(data: ShipmentResource::collection(Shipment::where('delivery_id', auth()->user()->id)
            ->where('company_id',  CompanyHelper::getId())
            ->where('status', 4)
            ->orWhere('status', 5)
            ->orWhere('status', 6)
            ->get()));
    }
    public function getPreviousShipments()
    {
        // previous shipments = rejected shipments  + completed shipments (status =6)
        $completedShipments = Shipment::where('delivery_id', auth()->user()->id)
            ->where('company_id',  CompanyHelper::getId())
            ->where('status', 7)
            ->get();
        $rejectedShipments = auth()->user()->rejectedShipments;
        $completedShipmentsResource = ShipmentResource::collection($completedShipments);
        $rejectedShipmentsResource = ShipmentResource::collection($rejectedShipments);
        return $this->apiResponse(data: [
            'completed' => $completedShipmentsResource,
            'rejected' => $rejectedShipmentsResource,
        ]);
    }
    public function getReturnedShipments()
    {

        return $this->apiResponse(data: ShipmentResource::collection(Shipment::where('delivery_id', auth()->user()->id)
            ->where('company_id',  CompanyHelper::getId())
            ->where('status', 8)
            ->get()));
    }
    public function updateShipmentStatus(UpdateShipmentStatusRequest $request, $id)
    {
        // 5 => pending
        // 6 => client accepted
        // 7 => client rejected

        $shipment = Shipment::where('id', $id)
            ->where('company_id',  CompanyHelper::getId())
            ->where('delivery_id', auth()->user()->id)
            ->first();
        if (!$shipment) {
            throw  new ModelNotFoundException();
        }
        $shipment->update([
            'status' => $request->status,
        ]);
        return $this->apiResponse(data: ShipmentResource::make($shipment), message: __('messages.shipment_status_updated_successfully'));
    }

    public function cancelShipment(CancelShipmentRequest $request, $id)
    {
        $deliveryId = auth('delivery')->id();
        $shipment = Shipment::where('id', $id)
            ->where('company_id',  CompanyHelper::getId())
            ->where('delivery_id',  $deliveryId)
            ->first();
        if (!$shipment) {
            throw  new ModelNotFoundException();
        }
        $shipment->delivery_id = null;
        $shipment->status = 2;
        $shipment->save();
        RejectedShipment::create([
            'reason' => $request->reason,
            'delivery_id' =>  $deliveryId,
            'shipment_id' => $id,
        ]);

        return $this->apiResponse(message: __('messages.shipment_cancelled'));
    }
}
