<?php

namespace App\Http\Controllers\Api\Shipments;

use App\Http\Controllers\Controller;
use App\Http\Helper\CompanyHelper;
use App\Http\Requests\AssignShipmentToDeliveryRequest;
use App\Http\Requests\ShipmentRequest;
use App\Http\Requests\UpdateShipmentStatusRequest;
use App\Http\Resources\ShipmentResource;
use App\Http\Services\NotificationService;
use App\Http\Services\Shipments\ShipmentService;
use App\Mail\ShippmentStatusMail;
use App\Models\Shipment;
use App\Trait\ApiTrait;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Support\Facades\Mail;
class ShipmentStatusController extends Controller
{
    use ApiTrait;

   
    public function updateShipmentStatus(UpdateShipmentStatusRequest $request, $id)
    {
        $this->authorize('updateShipmentStatus shipments');
        $shipment = Shipment::where('id', $id)
            ->where('company_id',  CompanyHelper::getId())
            ->first();
        $shipment->update([
            'status' => $request->status,
        ]);


        return $this->apiResponse(data: ShipmentResource::make($shipment), message: __('messages.shipment_status_updated_successfully'));
    }

    public function acceptShipmentFromClient($id)
    {
         $this->authorize('accept shipments');

        $shipment = Shipment::where('id', $id)
            ->where('company_id',  CompanyHelper::getId())
            ->where('status',  1)
            ->first();
        if (!$shipment) {
            throw  new ModelNotFoundException();
        }
        $shipment->update([
            'status' => 2,
        ]);

        Mail::to($shipment->sender->email)->send(new ShippmentStatusMail( 'shippment accepted successfully'));
        return $this->apiResponse(message: __('messages.shipment_accepted'));
    }
    public function assignShipmentForDelivery(AssignShipmentToDeliveryRequest $request, $id)
    {
        $this->authorize('assign shipments');

        $shipment = Shipment::where('id', $id)
            ->where('company_id',  CompanyHelper::getId())
            ->where('status',  2)
            ->first();

        if (!$shipment) {
            throw  new ModelNotFoundException();
        }
        $shipment->status = 3;
        $shipment->delivery_id = $request->delivery_id;
        $shipment->save();

        // NotificationService::sendNotificationToDelivery($request->delivery_id);
        Mail::to($shipment->sender->email)->send(new ShippmentStatusMail( 'shippment assigned to delivery successfully'));
        return $this->apiResponse(message: __('messages.shipment_assigned'));
    }
    
     public function deliverShipmentForDelivery($id)
    {
     

        $shipment = Shipment::where('id', $id)
            ->where('company_id',  CompanyHelper::getId())
            ->where('status',  3)
            ->first();
        if (!$shipment) {
            throw  new ModelNotFoundException();
        }
        $shipment->update([
            'status' => 4,
        ]);
        Mail::to($shipment->sender->email)->send(new ShippmentStatusMail( 'deliery take the shippment successfully'));
        return $this->apiResponse(message: __('messages.shipment_delivered_delivery'));
    }
     public function processingShipment($id)
    {
       
        $shipment = Shipment::where('id', $id)
            ->where('company_id',  CompanyHelper::getId())
            ->where('status',  4)
            ->first();
        if (!$shipment) {
            throw  new ModelNotFoundException();
        }
        $shipment->update([
            'status' => 5,
        ]);
        return $this->apiResponse(message: __('messages.shipment_processing'));
    }
     public function deliveredShipment($id)
    {

        $shipment = Shipment::where('id', $id)
            ->where('company_id',  CompanyHelper::getId())
            ->where('status',  5)
            ->first();
        if (!$shipment) {
            throw  new ModelNotFoundException();
        }
        $shipment->update([
            'status' => 6,
        ]);

        Mail::to($shipment->sender->email)->send(new ShippmentStatusMail( 'shippment delivered successfully'));
        return $this->apiResponse(message: __('messages.shipment_delivered'));
    }
     public function canceledShipment($id)
    {
      

        $shipment = Shipment::where('id', $id)
            ->where('company_id',  CompanyHelper::getId())
            ->where('status',  6)
            ->first();
        if (!$shipment) {
            throw  new ModelNotFoundException();
        }
        $shipment->update([
            'status' => 7,
        ]);
        Mail::to($shipment->sender->email)->send(new ShippmentStatusMail( 'shippment canceled successfully'));
        return $this->apiResponse(message: __('messages.shipment_canceled'));
    }
    //uuu
}
