<?php

namespace App\Http\Controllers\Api\Shipments;

use App\Http\Controllers\Controller;
use App\Http\Helper\CompanyHelper;
use App\Http\Requests\ShipmentTypeRequest;
use App\Http\Resources\ShipmentTypeResource;
use App\Http\Resources\ShipmentTypeDetailResource;
use App\Models\ShipmentType;
use App\Trait\ApiTrait;

class ShipmentTypeController extends Controller
{
    use ApiTrait;

    public function index()
    {
        $this->authorize('view shipment_types');
        return $this->apiResponse(data: ShipmentTypeResource::collection(ShipmentType::where('company_id', CompanyHelper::getId())->get()));
    }

    public function show($id)
    {
        $this->authorize('view shipment_types');
        return $this->apiResponse(data: ShipmentTypeDetailResource::make(ShipmentType::findOrFail($id)));
    }


    public function store(ShipmentTypeRequest $request)
    {
        $this->authorize('view shipment_types');

        return $this->apiResponse(data: ShipmentTypeResource::make(ShipmentType::create($request->only([
            'name',
            'company_id',
            'weight',
            'price_per_kg',
            'main_price',
            'location_id',
        ]))), message: __('messages.shipment_type_created_successfully'));
    }

    public function update(ShipmentTypeRequest $request, $id)
    {
        $this->authorize('view shipment_types');
        $shipmentItemType = ShipmentType::findOrFail($id);
        $shipmentItemType->update($request->only([
            'name',
            'company_id',
            'weight',
            'price_per_kg',
            'main_price',
              'location_id',
        ]));
        return $this->apiResponse(data: ShipmentTypeResource::make($shipmentItemType), message: __('messages.shipment_type_updated_successfully'));
    }

    public function destroy($id)
    {
        $this->authorize('delete shipment_types');
        $shipmentItemType = ShipmentType::findOrFail($id);
        $shipmentItemType->delete();
        return $this->apiResponse(message: __('messages.shipment_type_deleted_successfully'));
    }
}
