<?php

namespace App\Http\Controllers;

use App\Models\Company;
use App\Trait\ApiTrait;
use Illuminate\Http\Request;
use App\Models\CompanyMainSettings;
use App\Http\Resources\CompanyMainSettingResource;

class CompanyMainSettingsController extends Controller
{
    use ApiTrait;

    public function index()
    {
        $main_settings = Company::find(auth()->id())->mainSettings;
        $main_settings = CompanyMainSettingResource::collection($main_settings);
        return $this->apiResponse(data: $main_settings);
    }

    public function update(CompanyMainSettings $companyMainSettings)
    {
        $companyMainSettings->update([
            'status' => (!$companyMainSettings->status),
        ]);
        $companyMainSettings = new CompanyMainSettingResource($companyMainSettings);
        return $this->apiResponse(message: __('messages.setting_status_updated_successfully'), data: $companyMainSettings);
    }
}
