<?php

namespace App\Http\Controllers;

use App\Http\Helper\CompanyHelper;
use App\Http\Resources\AccountResource;
use Illuminate\Http\Request;
use App\Models\Account;
use App\Trait\ApiTrait;

class ReportController extends Controller
{
    use ApiTrait;
    public function getIncomeListReport()
    {
        $accounts = Account::where('company_id', CompanyHelper::getId())
            ->where(function ($query) {
                $query->where('code', '4') //revenues
                    ->orWhere('code', '5'); // expenses
            })->with('children')->get();
        return $this->apiResponse(data: AccountResource::collection($accounts));
    }
    public function getFinancialCenterReport()
    {
        $accounts = Account::where('company_id', CompanyHelper::getId())
            ->where(function ($query) {
                $query->where('code',  '1')
                    ->orWhere('code',  '2')
                    ->orWhere('code',  '3');
            })
            ->with(['children'])
            ->get();
        return $this->apiResponse(data: AccountResource::collection($accounts));
    }
}
