<?php

namespace App\Http\Enums\Order;


enum OrderStatusEnum: int
{
    case PENDING = 0;
    case ACCEPTED = 1;
    case REJECTED = 2;
    case DELIVERED = 3;
    case PROCESSING = 4;

    public static function getOrderStatuses(): array
    {
        $statues = [];

        foreach (self::cases() as  $status) {
            $statues[] = strtolower($status->name);
        }

        return $statues;
    }

    public static function getValueFromName(string $name): int
    {
        foreach (self::cases() as  $status) {
            if (strtolower($status->name) == $name) {
                return $status->value;
            }
        }

        return self::PENDING->value;
    }
}
