<?php

namespace App\Http\Enums\Product;


enum ProductTypeEnum: int
{
    case SELLING_TYPE = 1;
    case SERVICE_TYPE = 2;
    case BOTH_TYPE = 3;
    case SALES_SUPPLIES = 4;
    case RAW_MATERIAL = 5;

    public static function getTypes(): array
    {
        return [
            self::SELLING_TYPE->value,
            self::SERVICE_TYPE->value,
            self::BOTH_TYPE->value,
            self::SALES_SUPPLIES->value,
            self::RAW_MATERIAL->value,
        ];
    }
    public static function getArabicTypes(): array
    {
        return [
            self::SELLING_TYPE->value => 'منتج',
            self::SERVICE_TYPE->value => 'خدمة',
            self::BOTH_TYPE->value => 'منتج مجمع',
            self::SALES_SUPPLIES->value => 'مستلزمات بيعية',
            self::RAW_MATERIAL->value => 'مادة اولية',
        ];
    }
    public static function getValueFromArabicType(string $arabicType): int
    {
        return array_flip(self::getArabicTypes())[$arabicType];
    }
}
