<?php

namespace App\Http\Helper;

use App\Models\Account;
use App\Models\AccountModelGroup;
use App\Trait\AccountHelperTrait;
use Illuminate\Support\Facades\DB;

class AccountHelper
{
    use AccountHelperTrait;

    const ACCOUNT_PRODUCTS = 'products';
    const ACCOUNT_PURCHASE_VALUE_TAX = 'purchase_value_tax';
    const ACCOUNT_SUPPLIERS = 'suppliers';
    const ACCOUNT_EARNED_DISCOUNT = 'earned_discount';
    const ACCOUNT_CLIENTS = 'clients';
    const ACCOUNT_PRODUCTS_COSTS = 'products_costs';
    const ACCOUNT_SALES = 'sales';
    const ACCOUNT_SALES_VALUE_TAX = 'sales_value_tax';
    const ACCOUNT_ALLOWED_DISCOUNT = 'allowed_discount';
    const ACCOUNT_OPEN_BALANCE = 'open_balance';
    const ACCOUNT_TREASURIES = 'treasuries';
    const ACCOUNT_BANKS = 'banks';
    const ACCOUNT_NETWORKS = 'networks';
    const ACCOUNT_HOLDERS = 'holders';
    const ACCOUNT_SERVICE_SALES = 'service_sales';
    const ACCOUNT_SERVICE_PRODUCTS_COSTS = 'service_products_costs';
    const ACCOUNT_SUPPLIES_WAREHOUSE = 'supplies_warehouse';
    const ACCOUNT_SERVICE_EXPENSES = 'services_expenses';
    const ACCOUNT_DAMAGE = 'inventory_damage';
    const ACCOUNT_INVENTORY_LOSSES = 'inventory_losses';
    const ACCOUNT_INVENTORY_REVENUES = 'inventory_revenues';
    const CASH_REMAIN = 'cash_remain';

    const MODELS = [
        [
            'name' => self::ACCOUNT_INVENTORY_LOSSES,
            'label' => [
                'ar' => 'خسائر تسوية جردية',
                'en' => 'Inventory Losses',
            ],
        ],
        [
            'name' => self::CASH_REMAIN,
            'label' => [
                'ar' => 'فروقات فواتير المبيعات',
                'en' => 'Sales invoice differences',
            ],
        ],
        [
            'name' => self::ACCOUNT_INVENTORY_REVENUES,
            'label' => [
                'ar' => 'إيراد تسوية جردية',
                'en' => 'Inventory Revenues',
            ],
        ],
        [
            'name' => self::ACCOUNT_SUPPLIERS,
            'label' => [
                'ar' => 'الموردين',
                'en' => 'suppliers account',
            ],
        ],

        [
            'name' => self::ACCOUNT_DAMAGE,
            'label' => [
                'ar' => 'اتلاف مخزون',
                'en' => 'inventory damage',
            ],
        ],
        [
            'name' => self::ACCOUNT_CLIENTS,
            'label' => [
                'ar' => 'العملاء',
                'en' => 'clients',
            ],
        ],
        [
            'name' => self::ACCOUNT_PRODUCTS,
            'label' => [
                'ar' => 'المنتجات',
                'en' => 'products',
            ],
        ],
        [
            'name' => self::ACCOUNT_OPEN_BALANCE,
            'label' => [
                'ar' => 'الرصيد الافتتاحي',
                'en' => 'open balance',
            ],
        ],
        [
            'name' => self::ACCOUNT_PRODUCTS_COSTS,
            'label' => [
                'ar' => 'تكلفة المنتجات',
                'en' => 'products costs',
            ],
        ],
        [
            'name' => self::ACCOUNT_TREASURIES,
            'label' => [
                'ar' => 'الخزن',
                'en' => 'treasuries',
            ],
        ],
        [
            'name' => self::ACCOUNT_BANKS,
            'label' => [
                'ar' => 'البنوك',
                'en' => 'banks',
            ],
        ],
        [
            'name' => self::ACCOUNT_NETWORKS,
            'label' => [
                'ar' => 'الشبكات',
                'en' => 'networks',
            ],
        ],
        [
            'name' => self::ACCOUNT_HOLDERS,
            'label' => [
                'ar' => 'امناء',
                'en' => 'holders',
            ],
        ],
        [
            'name' => self::ACCOUNT_ALLOWED_DISCOUNT,
            'label' => [
                'ar' => 'خصم مسموح به',
                'en' => 'allowed discount',
            ],
        ],
        [
            'name' => self::ACCOUNT_SALES,
            'label' => [
                'ar' => 'المبيعات',
                'en' => 'sales',
            ],
        ],
        [
            'name' => self::ACCOUNT_SALES_VALUE_TAX,
            'label' => [
                'ar' => 'الضريبة',
                'en' => 'sales taxes',
            ],
        ],
        [
            'name' => self::ACCOUNT_PURCHASE_VALUE_TAX,
            'label' => [
                'ar' => 'ضرائب المشتريات',
                'en' => 'purchase taxes',
            ],
        ],
        [
            'name' => self::ACCOUNT_EARNED_DISCOUNT,
            'label' => [
                'ar' => 'خصم مكتسب',
                'en' => 'earned discount',
            ],
        ],
        [
            'name' => self::ACCOUNT_SERVICE_PRODUCTS_COSTS,
            'label' => [
                'ar' => 'تكلفة الخدمات',
                'en' => 'service products costs',
            ],
        ],
        [
            'name' => self::ACCOUNT_SUPPLIES_WAREHOUSE,
            'label' => [
                'ar' => 'مستلزمات الخدمات',
                'en' => 'service supplies',
            ],
        ],
        [
            'name' => self::ACCOUNT_SERVICE_SALES,
            'label' => [
                'ar' => 'ايراد الخدمات',
                'en' => 'service sales',
            ],
        ],
        [
            'name' => self::ACCOUNT_SERVICE_EXPENSES,
            'label' => [
                'ar' => 'مصروف الخدمات',
                'en' => 'service expenses',
            ],
        ],

    ];

    public static function getNameForModel(string $name)
    {
        foreach (self::MODELS as $model) {
            if ($model['name'] === $name) {
                return $model['label'][app()->getLocale()];
            }
        }
    }

    /**
     * Initiates the copying of all accounts from a source company to a new company.
     *
     * This method starts a database transaction to ensure data integrity during the copy process.
     */
    public static function copyAccounts(): void
    {

        // Start transaction to ensure data integrity
        // DB::transaction(function () {
        // Fetch all accounts of the source company with their children in one query

        //delete default accounts
        DB::beginTransaction();
        Account::where('company_id', CompanyHelper::getId())->forcedelete();

        $sourceAccounts = Account::with('children')
            ->where('company_id', self::getMainCompanyId())
            ->get();

        // Filter root accounts (those without a parent)
        $rootAccounts = $sourceAccounts->where('parent_id', null);

        // Copy each root account and its children

        foreach ($rootAccounts as $rootAccount) {
            self::copyAccount($rootAccount);
        }

        self::copyAccountModel();
        DB::commit();

        return;
    }
    private static function copyAccountModel()
    {
        $companyId =  CompanyHelper::getId();
        foreach (self::getBaseAccountsCode() as $baseAccount) {
            foreach (self::getCurrentAccountsCode()  as $currentAccount) {
                if ($baseAccount['code'] === $currentAccount['code']) {
                    Account::find($currentAccount['id'])->models()->attach($baseAccount['model_id'], ['group_id' => $baseAccount['group_id'],  'company_id' => $companyId]);
                }
            }
        }
    }

    private static function getBaseAccountsCode()
    {

        return AccountModelGroup::where('company_id',  self::getMainCompanyId())
            ->with('account:id,code')
            ->get(['model_id', 'group_id', 'account_id'])
            ->map(function ($group) {
                return [
                    'group_id' => $group->group_id,
                    'model_id' => $group->model_id,
                    'code' => $group->account->code
                ];
            })->toArray();
    }
    private static function getCurrentAccountsCode()
    {

        return Account::where('company_id', CompanyHelper::getId())
            ->get(['id', 'code',])
            ->toArray();
    }
}

