<?php

namespace App\Http;

use Illuminate\Routing\Router;
use App\Http\Middleware\CompanyUnit;
use App\Http\Middleware\BranchCompany;
use App\Http\Middleware\ClientCompany;
use App\Http\Middleware\CompanyCareer;
use App\Http\Middleware\CompanyReason;
use Illuminate\Foundation\Application;
use App\Http\Middleware\AccountCompany;
use App\Http\Middleware\CheckAttribute;
use App\Http\Middleware\CompanyProduct;
use App\Http\Middleware\CompanySection;
use App\Http\Middleware\LangMiddleware;
use App\Http\Middleware\CompanyCurrency;
use App\Http\Middleware\CompanySupplier;
use App\Http\Middleware\ForceAcceptJson;
use App\Http\Middleware\AttributeCompany;
use App\Http\Middleware\CompanyWarehouse;
use App\Http\Middleware\CompanyMainSetting;
use App\Http\Middleware\CompanyGroupSetting;
use App\Http\Middleware\ChangeLangMiddleware;
use App\Http\Middleware\CompanySecretKeyAuth;
use App\Http\Middleware\CheckCompanyHasFeature;
use Illuminate\Foundation\Http\Kernel as HttpKernel;

class Kernel extends HttpKernel
{

    public function __construct(Application $app, Router $router)
    {
        parent::__construct($app, $router);

        // $this->prependToMiddlewarePriority(CompanySecretKeyAuth::class);
    }

    /**
     * The application's global HTTP middleware stack.
     *
     * These middleware are run during every request to your application.
     *
     * @var array<int, class-string|string>
     */
    protected $middleware = [
        // \App\Http\Middleware\TrustHosts::class,
        \App\Http\Middleware\TrustProxies::class,
        \Illuminate\Http\Middleware\HandleCors::class,
        \App\Http\Middleware\PreventRequestsDuringMaintenance::class,
        \Illuminate\Foundation\Http\Middleware\ValidatePostSize::class,
        \App\Http\Middleware\TrimStrings::class,
        \Illuminate\Foundation\Http\Middleware\ConvertEmptyStringsToNull::class,
    ];

    /**
     * The application's route middleware groups.
     *
     * @var array<string, array<int, class-string|string>>
     */
    protected $middlewareGroups = [
        'web' => [
            \App\Http\Middleware\EncryptCookies::class,
            \Illuminate\Cookie\Middleware\AddQueuedCookiesToResponse::class,
            \Illuminate\Session\Middleware\StartSession::class,
            // \Illuminate\Session\Middleware\AuthenticateSession::class,
            \Illuminate\View\Middleware\ShareErrorsFromSession::class,
            \App\Http\Middleware\VerifyCsrfToken::class,
            \Illuminate\Routing\Middleware\SubstituteBindings::class,
        ],

        'api' => [
            ForceAcceptJson::class,
            // \Laravel\Sanctum\Http\Middleware\EnsureFrontendRequestsAreStateful::class,
            'throttle:api',
            \Illuminate\Routing\Middleware\SubstituteBindings::class,
        ],
    ];

    /**
     * The application's route middleware.
     *
     * These middleware may be assigned to groups or used individually.
     *
     * @var array<string, class-string|string>
     */
    protected $routeMiddleware = [
        'secret-key-auth' => CompanySecretKeyAuth::class,
        'auth' => \App\Http\Middleware\Authenticate::class,
        'auth.basic' => \Illuminate\Auth\Middleware\AuthenticateWithBasicAuth::class,
        'cache.headers' => \Illuminate\Http\Middleware\SetCacheHeaders::class,
        'can' => \Illuminate\Auth\Middleware\Authorize::class,
        'guest' => \App\Http\Middleware\RedirectIfAuthenticated::class,
        'password.confirm' => \Illuminate\Auth\Middleware\RequirePassword::class,
        'signed' => \Illuminate\Routing\Middleware\ValidateSignature::class,
        'throttle' => \Illuminate\Routing\Middleware\ThrottleRequests::class,
        'verified' => \Illuminate\Auth\Middleware\EnsureEmailIsVerified::class,
        'cors' => \App\Http\Middleware\Cors::class,
        'lang' => LangMiddleware::class,
        'change-lang' => ChangeLangMiddleware::class,
        'attribute-check' => CheckAttribute::class,
        'attribute-company' => AttributeCompany::class,
        'check-client-company' => ClientCompany::class,
        'check-company-supplier' => CompanySupplier::class,
        'check-company-reason' => CompanyReason::class,
        'account-company' => AccountCompany::class,
        'company-product' => CompanyProduct::class,
        'company-group-setting' => CompanyGroupSetting::class,
        'branch-company' => BranchCompany::class,
        'company-warehouse' => CompanyWarehouse::class,
        'company-unit' => CompanyUnit::class,
        'company-currency' => CompanyCurrency::class,
        'company-main-setting' => CompanyMainSetting::class,
        'company-section' => CompanySection::class,
        'company-career' => CompanyCareer::class,
        'company-has-feature' => CheckCompanyHasFeature::class,
        'CompanySecretKeyAuth' => \App\Http\Middleware\CompanySecretKeyAuth::class,
    ];
}
