<?php

namespace App\Http\Middleware;

use Closure;
use App\Models\BlockReason;
use Illuminate\Http\Request;
use App\Http\Helper\CompanyHelper;
use Illuminate\Auth\Access\AuthorizationException;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;

class CompanyReason
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        if (CompanyHelper::getId() !== $request->reason->company_id) {
            throw new AuthorizationException;
        } elseif ($request->reason->option_label !== BlockReason::KEY) {
            throw new NotFoundHttpException;
        }
        return $next($request);
    }
}
