<?php

namespace App\Http\Middleware;

use App\Http\Helper\CompanyHelper;
use Closure;
use Illuminate\Http\Request;

class LangMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        if (auth('employee')->check()) {
            $parsed_url = parse_url($request->getRequestUri());
            $query_string = $parsed_url['query'] ?? "lang=en";
            // dd( $query_string);

            // Parse the query string into an associative array
            // if(  $query_string ){
            //     parse_str($query_string, $query_params);
            // }
            parse_str($query_string, $query_params);

            // Get the value of the 'lang' parameter
         
            app()->setLocale($query_params['lang'],"en");
            return $next($request);
        }
        if (auth()->check()) {
            app()->setLocale(CompanyHelper::getCompany()->lang ?? 'ar');
        } else {
            app()->setLocale($request->lang ?? 'ar');
        }
        return $next($request);
    }
}
