<?php

namespace App\Http\Repositories;

use App\Http\Interfaces\EmployeeAttendancesRepositoryInterface;
use App\Models\EmployeeAttendance;

class EmployeeAttendancesRepository implements EmployeeAttendancesRepositoryInterface
{
    public function all()
    {
        return EmployeeAttendance::with(['employee', 'attendMethod'])->get();
    }
    
    public function paginate($count)
    {
        return EmployeeAttendance::with(['employee', 'attendMethod'])->paginate($count);
    }
}