<?php

namespace App\Http\Repositories;

use App\Http\Interfaces\FingerprintReportRepositoryInterface;
use App\Models\EmployeeAttendance;

class FingerprintReportRepository implements FingerprintReportRepositoryInterface
{
    public function all()
    {
        return EmployeeAttendance::where('attend_method_id', 3)->with('employee')->get();
    }
    
    public function filter($data)
    {
        $selectedBranchId = $data['branch']; // Replace with the ID of the selected branch

        return EmployeeAttendance::whereHas('employee.branches', function ($query) use ($selectedBranchId) {
            $query->where('branch_id', $selectedBranchId);
        })->whereHas('employee', function ($employee) use($data){
            $employee->where('id', $data['employee']);
        })->whereBetween('created_at', [$data['from'], $data['to']])->get();
    }
}
