<?php

namespace App\Http\Repositories;

use App\Models\Supplier;
use App\Http\Interfaces\SupplierRepositoryInterface;

class SupplierRepository implements SupplierRepositoryInterface
{
    public function getAll()
    {
        // return Supplier::first();
        return Supplier::where('company_id', auth()->id())->with(['address'])->get();
    }

    public function show($supplier)
    {
        return $supplier->load(['address']);
    }

    public function store($data)
    {
        return Supplier::create($data);
    }

    public function update($supplier, $data)
    {
        return $supplier->update($data);
    }

    public function delete($supplier)
    {
        return $supplier->delete();
    }
}
