<?php

namespace App\Http\Requests\Api\Account;

use App\Models\Account;
use App\Rules\AccountTypeSameParent;
use App\Rules\AccountValidationType;
use App\Rules\NewAccountValidateType;
use App\Rules\MainAccountValidationRule;
use App\Rules\ParentCodeLength;
use Illuminate\Foundation\Http\FormRequest;

class StoreAccountRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return  [
            'name' => 'nullable|array',
            'description' => 'nullable|array',
            'name_ar' => 'required|string',
            'name_en' => 'nullable|string',
            'description_ar' => 'nullable|string',
            'description_en' => 'nullable|string',
            'active' => 'required|boolean',
            'amount' => 'required|numeric',
            'parent_id' => [
                'nullable',
                'exists:accounts,id',
                new AccountValidationType('main'),
                new ParentCodeLength(),
            ],
            'status' => [
                'required',
                'in:main,sub',
                new NewAccountValidateType($this->parent_id)
            ],
            'type' => [
                'required',
                'in:debit,credit',
                new AccountTypeSameParent($this->account->type ?? null)
            ],
        ];
    }

    public function prepareForValidation()
    {
        $this->merge([
            'active' => $this->active == 'on',
            'amount' => 0,
            'name' => [
                'ar' => $this->name_ar,
                'en' => $this->name_en ? $this->name_en : $this->name_ar,
            ],
            'description' => [
                'ar' => $this->description_ar,
                'en' => $this->description_en,
            ],
            'parent_id' => $this->account->id ?? null,
        ]);
    }
}
