<?php

namespace App\Http\Requests\Api\Admin\Feature;

use Illuminate\Foundation\Http\FormRequest;

class UpdateFeatureRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        
        $rules= [
            "title" =>"nullable|array",
           "title_ar" =>"required|string",
           "title_en" =>"required|string",
           "type" =>"sometimes|in:Feature,WhoAreContent,WhoAreHeader,About,Blog",
           "content" =>"nullable|array",
            "content_ar" =>"nullable|string",
           "content_en" =>"nullable|string",
           "description" =>"nullable",
            "description_ar" =>"nullable|string",
           "description_en" =>"nullable|string",
           "image" =>"nullable|file"
           
          
        ];

    return $rules;
    }

    protected function prepareForValidation()
    {
        $this->merge([
            'title' => [
                'ar' => $this->title_ar,
                'en' => $this->title_en,
            ],
            'content' => [
                'ar' => $this->content_ar,
                'en' => $this->content_en,
            ],
             'description' => [
                'ar' => $this->description_ar,
                'en' => $this->description_en,
            ],
        ]);
    }
}
