<?php

namespace App\Http\Requests\Api\Admin\Location;

use Illuminate\Foundation\Http\FormRequest;

class LocationRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name' => 'nullable|array',
            'name_ar' => 'required|string',
            'name_en' => 'required|string',
            'parent_id' => 'nullable|integer|exists:locations,id',
        ];
    }

    protected function prepareForValidation()
    {
        $this->merge([
            'name' => [
                'ar' => $this->name_ar,
                'en' => $this->name_en,
            ]
        ]);
    }
}
