<?php

namespace App\Http\Requests\Api\Branch;

use App\Models\Branch;
use App\Models\Address;
use App\Rules\ValidateArea;
use Illuminate\Foundation\Http\FormRequest;

class UpdateBranchRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return array_merge(Branch::RULES, Address::RULES, ['city_id' => ['nullable', 'exists:locations,id', new ValidateArea]]);
    }

    public function prepareForValidation()
    {
        return $this->merge([
            'home_service' => $this->home_service == 'on',
            'beauty_expert' => $this->beauty_expert == 'on',
            // 'delivers' => $this->delivers == 'on',
            'name' => [
                'ar' => $this->name_ar,
                'en' => $this->name_en,
            ],
            'address_line' => [
                'ar' => $this->address_line_ar,
                'en' => $this->address_line_en,
            ],
        ]);
    }
}
