<?php

namespace App\Http\Requests\Api\Client;

use App\Models\Client;
use Illuminate\Validation\Rule;
use App\Rules\UniqueCompanyPhone;
use App\Rules\UniqueSpecialClient;
use App\Http\Enums\User\UserStatusEnum;
use Illuminate\Foundation\Http\FormRequest;

class UpdateClientRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return array_merge(Client::RULES, [
            'phone' => ['required', new UniqueCompanyPhone(Client::class, $this->client->id)],
            'email' => 'nullable|email|unique:clients,email,' .  $this->client->id,
            'special' => ['nullable', 'boolean', new UniqueSpecialClient],
            'status' => ['nullable', Rule::in(array_values(UserStatusEnum::values()))],

        ]);
    }

    public function prepareForValidation()
    {
        $this->merge([
            'code' => $this->client->code,
            'company_id' => auth()->id(),
            // 'status' => $this->status == 'on' ? true : false,
            'is_client' => $this->is_client == 'on' ? true : false,
            'cache' => $this->cache == 'on' ? true : false,
            'internet' => $this->internet == 'on' ? true : false,
            'fingerprint' => $this->fingerprint == 'on' ? true : false,
            'gender' => $this->gender == 1 ? 'male' : 'female',
            'address_line' => [
                'ar' => $this->address_line_ar,
                'en' => $this->address_line_en
            ],
        ]);
    }
}
