<?php

namespace App\Http\Requests\Api\Company\Currency;

use App\Models\CompanyCurrency;
use Illuminate\Foundation\Http\FormRequest;

class UpdateCompanyCurrencyRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return CompanyCurrency::RULE;
    }

    public function prepareForValidation()
    {
        $this->merge([
            'name' => [
                'ar' => $this->name_ar,
                'en' => $this->name_en,
            ],
            'code' => [
                'ar' => $this->code_ar,
                'en' => $this->code_en,
            ],
        ]);
    }
}
