<?php

namespace App\Http\Requests\Api\Company\Expense;

use App\Http\Helper\CompanyHelper;
use Illuminate\Foundation\Http\FormRequest;

class ExpenseRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'name' => 'nullable|array|size:2',
            'name_ar' => 'required|string',
            'name_en' => 'required|string',
            'account_id' => 'required|exists:accounts,id,company_id,' . CompanyHelper::getId(),
        ];
    }

    protected function prepareForValidation()
    {
        $this->merge([
            'name' => ['en' => $this->name_en, 'ar' => $this->name_ar],
        ]);
    }
}
