<?php

namespace App\Http\Requests\Api\Company\PermissionRequest;

use App\Models\PermissionRequest;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\ValidationException;

class UpdatePermissionRequestRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return array_merge(PermissionRequest::RULES, [
            'employee_id' => 'required|exists:employees,id,company_id,' . auth()->id() . ',deleted_at,NULL',
        ]);
    }
}
