<?php

namespace App\Http\Requests\Api\Company;

use App\Http\Helper\CompanyHelper;
use App\Models\Company;
use Illuminate\Foundation\Http\FormRequest;

class ProfileRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            'email' => 'required|unique:companies,email,' . CompanyHelper::getId(),
            'phone' => 'required|unique:companies,phone,' . CompanyHelper::getId(),
            'logo' => 'nullable|image',
            'password' => 'nullable|confirmed',
        ] + Company::ROLE;
    }
}
