<?php

namespace App\Http\Requests\Api\Company\Role;

namespace App\Http\Requests\Api\Company\Role;

use App\Http\Helper\CompanyHelper;
use Illuminate\Validation\ValidationException;
use App\Models\Company;
use Illuminate\Validation\Rule;
use Illuminate\Foundation\Http\FormRequest;

class StoreRoleRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
     public function rules()
    {
        return array_merge(Company::PERMISSIONS_RULES, [
            'name' => [
                'required',
                Rule::unique('roles')->where(function ($query) {
                    return $query->where('company_id', CompanyHelper::getId());
                }),
            ],
        ]);
    }

    public function withValidator($validator)
    {
        $validator->after(function ($validator) {
            if ($this->role && $this->role->company_id !== CompanyHelper::getId()) {
                throw ValidationException::withMessages(['role' => 'invalid role.']);
            }
        });
    }
}
