<?php

namespace App\Http\Requests\Api\Company;

use App\Models\Company;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Validator;

class StoreCompanyRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        if ($this->checkCompany()) {
            return array_merge(Company::ROLE, [
                'email' => 'required',
                'phone' => 'required',
                'logo' => 'nullable|image',
            ]);
        }

        return array_merge(Company::ROLE, [
            'email' => 'required|unique:companies,email',
            'phone' => 'required|unique:companies,phone',
            'logo' => 'nullable|image',
        ]);
    }


    protected function checkCompany()
    {
        return Company::where('email', $this->input('email'))
            ->whereNull('email_verified_at')
            ->exists();
    }
}
