<?php

namespace App\Http\Requests\Api\Company\Treasury;

use App\Http\Helper\CompanyHelper;
use App\Models\Treasury;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class StoreTreasuryRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {

        return array_merge(Treasury::RULES, [

            'branch_id' => 'required|exists:branches,id,company_id,' . CompanyHelper::getId(),

        ]);
    }

    public function prepareForValidation()
    {
        $this->merge([
            'name' => [
                'ar' => $this->name_ar,
                'en' => $this->name_ar,
            ],
            'status' => $this->status == 'on',
        ]);
    }
}
