<?php

namespace App\Http\Requests\Api\Employee\Employee;

use App\Models\Address;
use App\Models\Employee;
use App\Rules\ValidateArea;
use Illuminate\Foundation\Http\FormRequest;

class UpdateEmployeeRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return array_merge(Employee::RULES, Address::RULES, ['area_id' => ['nullable', 'exists:locations,id', new ValidateArea]], [
            'phone' => 'nullable|string|unique:employees,phone,' . $this->employee->id,
            'email' => 'nullable|email|unique:employees,email,' . $this->employee->id,
            'branches' => 'sometimes|array|min:1',
            'branches.*' => 'exists:branches,id',
            'password' => 'sometimes'
        ]);
    }

    public function prepareForValidation()
    {

        $this->merge([
            'status' => $this->status == 'on',
            'online' => $this->status == 'on',
            'calendar_appearance' => $this->status == 'on',
            'name' => [
                'ar' => $this->name_ar,
                'en' => $this->name_en,
            ],
            'address_line' => [
                'ar' => $this->address_line_ar,
                'en' => $this->address_line_en,
            ],
        ]);
    }
}
