<?php

namespace App\Http\Requests\Api\Journal;

use Illuminate\Foundation\Http\FormRequest;

class JournalReportRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'from' => 'nullable|date',
            'to' => 'nullable|date|after_or_equal:from',

            'account' => 'nullable|exists:accounts,id',

            'product' => 'nullable|array',
            'client' => 'nullable|array',
            'supplier' => 'nullable|array',
            'branch' => 'nullable|array',
            'warehouse' => 'nullable|array',

            'product.*' => 'nullable|exists:products,id|distinct',
            'client.*' => 'nullable|exists:clients,id|distinct',
            'supplier.*' => 'nullable|exists:suppliers,id|distinct',
            'branch.*' => 'nullable|exists:branches,id|distinct',
            'warehouse.*' => 'nullable|exists:warehouses,id|distinct',
        ];
    }

    protected function prepareForValidation()
    {
        $this->merge(
            [
                'product' => $this->product ?  explode(',', $this->product) : null,
                'client' => $this->client ? explode(',', $this->client) : null,
                'supplier' => $this->supplier ? explode(',', $this->supplier) : null,
                'branch' => $this->branch ? explode(',', $this->branch) : null,
                'warehouse' => $this->warehouse ? explode(',', $this->warehouse) : null,
            ]
        );
    }
}
