<?php

namespace App\Http\Requests\Api\OpenBalance;

use App\Http\Helper\AccountHelper;
use App\Http\Helper\CompanyHelper;
use App\Http\Services\Account\AccountService;
use Illuminate\Foundation\Http\FormRequest;

class StoreOpenBalanceRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $company = CompanyHelper::getCompany(request());
        return [
            'date' => 'required|date',
            'description' => 'nullable|string',
            'status' => 'required|in:draft,saved,accredited',

            'warehouse_id' => [
                'required',
                'exists:warehouses,id,company_id,' .  $company->id,
            ],
            'branch_id' => [
                'required',
                'exists:branches,id,company_id,' .  $company->id,
            ],
            'products' => 'required|array|min:1',
            'products.*.product_id' => 'required|exists:products,id,company_id,' .  $company->id,

            'products.*.unit_id' => [
                'required',
                'exists:company_units,id,company_id,' .  $company->id,
            ],
            'products.*.price' => 'required|numeric|min:1',
            'products.*.quantity' => 'required|numeric|min:1',
        ];
    }
}
