<?php

namespace App\Http\Requests\Api\Setting;

use App\Models\GroupSetting;
use Illuminate\Foundation\Http\FormRequest;

class UpdateGroupSettingRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return GroupSetting::ROLE;
    }

    public function prepareForValidation()
    {
        $this->merge([
            'name' => [
                'ar' =>   $this->name_ar,
                'en' =>   $this->name_en,
            ]
        ]);
    }
}
