<?php

namespace App\Http\Requests\Api\Shift\AutoShift;

use App\Http\Helper\CompanyHelper;
use App\Rules\WeekDayNameRule;
use Illuminate\Foundation\Http\FormRequest;

class AutoShiftRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'company_id' => 'required',
            'branch_id' => 'required|exists:branches,id',
            'days' => ['required', 'array'],
            'days.*' => ['required', 'string', new WeekDayNameRule, 'distinct'],
            'status' => 'required|boolean',

            'details' => 'required|array',
            'details.*.worker_id' => 'required|exists:workers,id|distinct',
            'details.*.treasury_id' => 'required|exists:treasuries,id',
            'details.*.amount' => 'required|numeric|min:0',
        ];
    }

    protected function prepareForValidation()
    {
        $this->merge([
            'company_id' => CompanyHelper::getId(),

        ]);
    }
}
