<?php

namespace App\Http\Requests\Api\Supplier\BlockSupplier;

use App\Models\BlockSupplier;
use Illuminate\Foundation\Http\FormRequest;

class UpdateBlockSupplierRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return array_merge(
            BlockSupplier::RULE,
            [
                'supplier_id' => 'required|exists:suppliers,id|unique:block_suppliers,supplier_id,' . $this->route()->supplier->id,
            ]
        );
    }

    public function prepareForValidation()
    {
        $this->merge([
            'status' => $this->status == 'on',
        ]);
    }
}
