<?php

namespace App\Http\Requests\Api\Supplier;

use App\Models\Address;
use App\Models\Supplier;
use App\Rules\ValidateArea;
use App\Rules\UniqueCompanyPhone;
use App\Rules\UniqueSpecialClient;
use Illuminate\Foundation\Http\FormRequest;

class StoreSupplierRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return array_merge(Supplier::RULES, Address::RULES, ['area_id' => ['nullable', 'exists:locations,id', new ValidateArea]], [
            'phone' => ['required', new UniqueCompanyPhone(Supplier::class)],
            'special' => ['nullable', 'boolean', new UniqueSpecialClient],
           
            // 'payment_data' => 'nullable',
            // 'payment_data.*.bank_name' => ['nullable', 'string'],
            // 'payment_data.*.bank_account_owner_name' => ['nullable', 'string'],
            // 'payment_data.*.account_number' => ['nullable', 'string'],
            // 'payment_data.*.currency_id' => ['nullable', 'exists:company_currencies,id'],
            // 'payment_data.*.iban_code' => ['nullable', 'string'],
            // 'payment_data.*.swift_code' => ['nullable', 'string'],
            // 'payment_data.*.country_id' => ['nullable', 'exists:locations,id'],
            // 'payment_data.*.bank_address' => ['nullable', 'string'],
        ]);
    }

    public function prepareForValidation()
    {
        $code = (Supplier::latest()->first()->code ?? 100) + 1;
        $this->merge([
            'address_line' => [
                'ar' => $this->address_line_ar ? $this->address_line_ar : $this->address_line_en,
                'en' => $this->address_line_en ? $this->address_line_en : $this->address_line_ar
            ],
            'name' => [
                'ar' => $this->name_ar ?: $this->name_en,
                'en' => $this->name_en ? $this->name_en : $this->name_ar
            ],
            'status' => $this->status == 'on' ? true : false,
            'code' => "$code",
            'company_id' => auth('company')->id() ?? auth('worker')->user()->company->id,
        ]);
    }
}
