<?php

namespace App\Http\Requests;

use App\Http\Helper\CompanyHelper;
use Illuminate\Foundation\Http\FormRequest;

class CompanyRevenuesRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'data' => 'required|array|min:1',
            'data.*.code' => 'required|integer',
            'data.*.type' => 'required|in:sales,rent',
            'data.*.date' => 'required|date',
            'data.*.client_name' => 'required|string|max:255',
            'data.*.phone' => 'required|string|max:255',
            'data.*.city' => 'required|string|max:255',
            'data.*.network' => 'required|numeric|min:0',
            'data.*.cash' => 'required|numeric|min:0',
            'data.*.transfer' => 'required|numeric|min:0',
            'data.*.electronic' => 'required|numeric|min:0',
            'data.*.wallet' => 'required|numeric|min:0',
            'data.*.tap' => 'required|numeric|min:0',
            'data.*.stc' => 'required|numeric|min:0',
            'data.*.mada' => 'required|numeric|min:0',
            'data.*.delivery_cost' => 'required|numeric|min:0',
            'data.*.total_without_taxes' => 'required|numeric|min:0',
            'data.*.tax' => 'required|numeric|min:0',
            'data.*.total' => 'required|numeric|min:0',

            //For Journals
            'data.*.credit_account' => 'required',
            'data.*.credit_account.name' => 'required|string',
            'data.*.credit_account.amount' => 'required|numeric',

            'data.*.debit_accounts' => 'required|array|min:1',
            'data.*.debit_account.*.name' => 'required|string',
            'data.*.debit_account.*.amount' => 'required|numeric',
        ];
    }
}
