<?php

namespace App\Http\Requests\Delivery;

use Illuminate\Foundation\Http\FormRequest;

class StoreDeliveryRequest extends FormRequest
{
    public function rules()
    {
        return
            [
                'name' => 'required|string',
                'type' => 'required|string|in:inner,outer',
                'phone' => 'required|string|unique:deliveries,phone',
                'branch_id' => 'required_if:type,inner|exists:branches,id,deleted_at,NULL',
                'employee_id' => 'required_if:type,inner|exists:employees,id,deleted_at,NULL|unique:deliveries,employee_id',
                'company_id' => 'required|exists:companies,id,deleted_at,NULL',
            ];
    }

    public function prepareForValidation()
    {
        $this->merge(
            [
                'company_id' => auth('company')->id() ?? auth('worker')->user()->company->id,
            ]
        );
    }
}
