<?php

namespace App\Http\Requests;

use App\Models\Employee;
use Illuminate\Foundation\Http\FormRequest;

class EmployeeAttendRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
         'employee_id' => 'nullable|exists:employees,id',
         'branch_id' => 'nullable|exists:branches,id',
         'method' => 'required|in:app,fingerprint,system',
         'start_date' => 'required|date',
         'image' => 'nullable|image',
         'start_time' => 'required|date_format:H:i:s',
        //  'end_time' => 'nullable|date_format:H:i:s',
        ];
    }
    protected function prepareForValidation()
    {
        // $employee_id = $this->input('employee_id');
        // $branch_id = null;

        // if ($employee_id) {
        //     $employee = Employee::find($employee_id);
        //     if ($employee) {
        //         $branch = $employee->branches()->first();
        //         if ($branch) {
        //             $branch_id = $branch->id ?? null;
        //         }
        //     }
        // }

        $this->merge([
            // 'branch_id' => $branch_id,
            'employee_id' => auth()->user()->id,
        ]);
    }
}
