<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class RevenuesRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'type' => 'required|in:sales,rent',
            'paymentMethod' => 'nullable|in:delivery,network,cash,transfer,electronic,wallet,tap,stc,mada',
            'from' => 'nullable|date',
            'to' => 'nullable|date',
            'code' => 'nullable',
        ];
    }
}
