<?php

namespace App\Http\Requests;

use App\Http\Helper\CompanyHelper;
use Illuminate\Foundation\Http\FormRequest;

class ShipmentReceiverRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'name' => 'required|nullable',
          
            'address' => 'required|string',
            'phone' => 'required|string',
            'company_id' => 'required|exists:companies,id',
            'client_id' => 'nullable|exists:clients,id'
        ];
    }

    public function prepareForValidation()
    {
        return $this->merge([
            // 'name' => [
            //     'ar' => $this->name_ar ? $this->name_ar : $this->name_en,
            //     'en' => $this->name_en ? $this->name_en : $this->name_ar,
            // ],
            'company_id' =>auth("client")->user() ?auth("client")->user()->company_id :  CompanyHelper::getId(),
        ]);
    }
}
