<?php

namespace App\Http\Requests;

use App\Http\Helper\CompanyHelper;
use App\Http\Services\Shipments\ShipmentService;
use Illuminate\Foundation\Http\FormRequest;

class ShipmentRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'tracking_code' =>'required|string',
            'company_id' => 'required|exists:companies,id',
            'sender_id' => 'required|exists:clients,id',
            'receiver_id' => 'required|exists:shipment_receiver,id',
            // 'branch_id' => 'required|exists:branches,id',
            'warehouse_id' => 'required|exists:warehouses,id',
            'from' => 'required|string',
            'to' => 'required|string',
            'type_id' => 'required|exists:shipment_types,id',
            'payment_method_id' => 'required|exists:payment_methods,id',
            'total_tax' => 'required|numeric',
            'total_discount' => 'required|numeric',
            'total_cost' => 'required|numeric',
            'delivery_type' => 'required|in:0,1',
            'notes' => 'nullable|string',

            //validation for items
            'items' => 'required|array|min:1', // To ensure the items  array has one item at least
            'items.*.notes' => 'nullable',
            // 'items.*.discount_type' => 'required|in:percentage,number',
            // 'items.*.discount' => 'required|numeric',
            'items.*.cost' => 'required|numeric',
            'items.*.total' => 'required|numeric',
            'items.*.weight' => 'required|numeric',
            'items.*.tax_id' => 'nullable|exists:taxes,id',
            'items.*.discount_id' => 'nullable|exists:discounts,id',
            'items.*.attachment' => 'nullable|file|max:2048',
            'items.*.item_id' => 'nullable|exists:shipment_item_types,id',
        ];
    }
    public function prepareForValidation()
    {
        return $this->merge([
            'company_id' => CompanyHelper::getId(),
            'tracking_code' =>ShipmentService::generateShipmentTrackingCode(),

        ]);
    }
}
