<?php

namespace App\Http\Requests;

use App\Http\Helper\CompanyHelper;
use Illuminate\Foundation\Http\FormRequest;

class StoreAppInformationRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $rules = [
            'employee_id' => 'nullable|exists:employees,id',
            'section_id' => 'nullable|exists:careers_sections,id',
            'type' => 'required|in:video,audio',

            'title' => 'nullable',
            'title_ar' => 'nullable|string',
            'title_en' => 'nullable|string',

            'content' => 'nullable',
            'content_ar' => 'nullable|string',
            'content_en' => 'nullable|string',
        ];
        if ($this->input('type') === 'video') {
            $rules['file'] = 'required|string';
        } elseif ($this->input('type') === 'audio') {
            $rules['file'] = 'required|file';
        }
        return $rules;
    }


    public function prepareForValidation()
    {
        $rules = [
            'title' => [
                'ar' => $this->title_ar,
                'en' => $this->title_en,
            ],
            'content' => [
                'ar' => $this->content_ar,
                'en' => $this->content_en,
            ],
        ];
        // if employee upload audio will be stored related to his section
        if (auth('employee')->check()) {
            $rules['section_id'] = auth()->user->section->id ?? null;
        }

        return $rules;
    }
}
