<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class AddressResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            "id" => $this->id,
            "city" =>  new LocationResource($this->whenLoaded('area')),
            "address_line" => $this->address_line,
            'address_line_ar' => $this->getTranslations('address_line')['ar'] ?? "",
            'address_line_en' => $this->getTranslations('address_line')['en'] ?? "",
            "post_code" => $this->post_code,
            "longitude" => $this->longitude,
            "latitude" => $this->latitude,
        ];
    }
}
