<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class AttendanceMethodResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            "id" => $this->id,
            // "company_id" => $this->company_id,
            "name" => $this->name,
            'name_ar' => $this->getTranslations('name')['ar'] ?? '',
            'name_en' => $this->getTranslations('name')['en'] ?? '',
            "short_code" => $this->short_code,
            "color" => $this->color,
            "days" => $this->days
        ];
    }
}
