<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class AutoShiftResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'days' => $this->days,
            'status' => $this->status,
            'branch' => BranchResource::make($this->whenLoaded('branch')),
            'shift_details' => AutoShiftDetailsResource::collection($this->whenLoaded('autoShiftDetails')),
        ];
    }
}
