<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class BillExpenseResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'expense' => ExpenseResource::make($this->whenLoaded('expense')),
            'bill' => BillResource::make($this->whenLoaded('bill')),
            'amount' => $this->amount,
        ];
    }
}
