<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class BillServiceResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'discount_type' => $this->discount_type,
            'discount_amount' => $this->discount_amount,
            'date' => $this->date,
            'tax_included' => $this->tax_included,
            'quantity' => $this->quantity,
            'from_total_discount' => $this->from_total_discount,
            'starts_at' => $this->starts_at,
              "price" => number_format($this->price, 2),
            'service' => ServiceResource::make($this->whenLoaded('service')),
            'branch' => BranchResource::make($this->whenLoaded('branch')),
            'bill' => BillResource::make($this->whenLoaded('bill')),
            'tax' => new TaxResource($this->whenLoaded('tax')),

        ];
    }
}
